% Vyhodnocen stednch integrlnch hodnot rychlosti sten a bonho zrychlen
% ze signl men i simulace manvru pro stanoven citlivosti na bon vtr 
% dle normy ISO 12012-1:1996
clear;
clc;

% nastaven
casename='AERO1';
pom.endname='_filt.mat';        % '.mat' bez dodatku za poadovm slem, '_XX.mat' s dodatkem
pom.velocity='110';             % rychlost v km/h, jen pro nzvy
data.time.pulsestart=1.4;       % potek foukn
data.time.pulsedur=0.98;        % doba foukn
data.time.total=4;              % sledovan doba
data.rate=200;                  % vzorkovac frekvence v Hz
modelfile='SK258-AERO1-FY.mat';

% pprava
pom.folder=strcat('./XW_',casename,'_FILTERED');
addpath(pom.folder);
mkdir(strcat(pom.folder,'/OUTPUT/'));
data.time.axis=0:(1/data.rate):data.time.total;

% natn dat
tic;
disp(' ');
disp('Computing...');
for prom=1:10
    disp(strcat('... run ',int2str(prom)));
    if prom<=9
        pom.name2='_0';
    else
        pom.name2='_';
    end;
    pom.name1=strcat('XW_',casename,'_',pom.velocity,'kmh_L_17ms');
    pom.name3=int2str(prom);
    pom.name=[pom.name1 pom.name2 pom.name3 pom.endname];

input=load(pom.name);
data.YR.in=input.input.yawRate_f;
data.AY.in=input.input.aY_f;
data.v.in=input.input.v;
data.x.in=input.input.x;

% odstrann zdvojench hodnot pro x
data.x.half=(1:(length(data.x.in)/2))';
for i=1:length(data.x.half);
    data.x.half(i)=data.x.in(2*i);
end;

% interpolace x na frekvenci YR a AY
pom.I=(1:length(data.x.half))';
data.x.interp=(interp1(pom.I,data.x.half,1:0.5:(length(data.x.in)/2+0.5),'linear','extrap'))';

% hodnota x nejbli 0
data.x.zero=min(abs(data.x.interp));
data.x.zeroindex=find(abs(data.x.interp)==data.x.zero);

% posun dat na 1,4s ped zatkem foukn
pom.II=round(data.time.pulsestart*data.rate);
data.YR.cut=(1:(length(data.YR.in)-(data.x.zeroindex-pom.II)))';
data.AY.cut=(1:(length(data.AY.in)-(data.x.zeroindex-pom.II)))';
data.v.cut=(1:(length(data.v.in)-(data.x.zeroindex-pom.II)))';
data.x.cut=(1:(length(data.x.interp)-(data.x.zeroindex-pom.II)))';

if data.x.zeroindex>pom.II
    for j=1:length(data.YR.cut)
        data.YR.cut(j)=data.YR.in(j+(data.x.zeroindex-pom.II));
        data.AY.cut(j)=data.AY.in(j+(data.x.zeroindex-pom.II));
        data.v.cut(j)=data.v.in(j+(data.x.zeroindex-pom.II));
        data.x.cut(j)=data.x.interp(j+(data.x.zeroindex-pom.II));
    end;
else
    disp('Missing start data set to zero');
    data.addlength=pom.II-data.x.zeroindex;
    data.YR.add1=(1:data.addlength)';
    data.YR.add1(1:length(data.YR.add1))=0;
    data.AY.add1=(1:data.addlength)';
    data.AY.add1(1:length(data.AY.add1))=0;
    pom.time1=1:length(data.v.in);
    data.v.add1ex=interp1(pom.time1,data.v.in,(data.x.zeroindex-pom.II):1:-1,'pchip','extrap');    
    data.x.add1=(1:data.addlength)';
    data.x.add1(1:length(data.x.add1))=min(data.x.in);
    data.YR.cut=1:(length(data.YR.add1)+length(data.YR.in));
    data.YR.cut=[data.YR.add1' data.YR.in']';
    data.AY.cut=1:(length(data.AY.add1)+length(data.AY.in));
    data.AY.cut=[data.AY.add1' data.AY.in']';
    data.v.cut=1:(length(data.v.add1ex)+length(data.v.in));
    data.v.cut=[data.v.add1ex data.v.in']';    
    data.x.cut=1:(length(data.x.add1)+length(data.x.in));
    data.x.cut=[data.x.add1' data.x.in']';
end;

% oznut/doplnn dat na 4s
pom.III=(data.time.total*data.rate)+2;
if length(data.YR.cut)>=pom.III
    data.YR.cut(pom.III:length(data.YR.cut))=[];
    data.AY.cut(pom.III:length(data.AY.cut))=[];
    data.v.cut(pom.III:length(data.v.cut))=[];
    data.x.cut(pom.III:length(data.x.cut))=[];
else
    disp('Missing end data set to zero');
    data.YR.add2=(1:(length(data.time.axis)-length(data.YR.cut)))';
    data.YR.add2(1:length(data.YR.add2))=0;
    data.AY.add2=(1:(length(data.time.axis)-length(data.AY.cut)))';
    data.AY.add2(1:length(data.AY.add2))=0;
    pom.time2=1:length(data.v.cut);
    data.v.add2ex=interp1(pom.time2,data.v.cut,(length(data.v.cut)+1):1:length(data.time.axis),'pchip','extrap');    
    data.x.add2=(1:(length(data.time.axis)-length(data.x.cut)))';
    data.x.add2(1:length(data.x.add2))=max(data.x.in);
    data.YR.cut=[data.YR.cut' data.YR.add2']';
    data.AY.cut=[data.AY.cut' data.AY.add2']';
    data.v.cut=[data.v.cut' data.v.add2ex]';
    data.x.cut=[data.x.cut' data.x.add2']';
end;

% PULSE VALUE YAW RATE
% poloha maxima
pulse.YR.max=max(abs(data.YR.cut));
pulse.YR.maxindex=find(abs(data.YR.cut)==pulse.YR.max);
pulse.YR.mid=pulse.YR.max/2;
% potek a konec intervalu
pulse.time.YRstart=fzero(@(a) interp1(data.time.axis,data.YR.cut-pulse.YR.mid,...
    a),data.time.pulsestart);
pulse.time.YRend=fzero(@(a) interp1(data.time.axis,data.YR.cut-pulse.YR.mid,...
    a),data.time.pulsestart+data.time.pulsedur);
% pulse value (integrace numericky)
data.YR.pulsecut=interp1(data.time.axis,data.YR.cut,...
    pulse.time.YRstart:0.0001:pulse.time.YRend,'pchip');
pulse.YR_numint=sum(data.YR.pulsecut)*0.0001;
pulse.PV_YRnum=pulse.YR_numint/(pulse.time.YRend-pulse.time.YRstart);
% pulse value (integrace matlab)
pom.YRtime=pulse.time.YRstart:(pulse.time.YRend-pulse.time.YRstart)/10000:pulse.time.YRend;
pom.YRspline=spline(data.time.axis,data.YR.cut,pom.YRtime);
pulse.YR_matlint=trapz(pom.YRtime,pom.YRspline);
pulse.PV_YRinteg=pulse.YR_matlint/(pulse.time.YRend-pulse.time.YRstart);
% zpis
pulse.YRvalues1(prom,1)=pulse.PV_YRnum;
pulse.YRvalues2(prom,1)=pulse.PV_YRinteg;

% PULSE VALUE LATERAL ACCELERATION
% poloha maxima
pulse.AY.max=max(abs(data.AY.cut));
pulse.AY.maxindex=find(abs(data.AY.cut)==pulse.AY.max);
pulse.AY.mid=pulse.AY.max/2;
% potek a konec intervalu
pulse.time.AYstart=fzero(@(a) interp1(data.time.axis,data.AY.cut-pulse.AY.mid,...
    a),data.time.pulsestart);
pulse.time.AYend=fzero(@(a) interp1(data.time.axis,data.AY.cut-pulse.AY.mid,...
    a),data.time.pulsestart+data.time.pulsedur);
% pulse value (integrace numericky)
data.AY.pulsecut=interp1(data.time.axis,data.AY.cut,...
    pulse.time.AYstart:0.0001:pulse.time.AYend,'pchip');
pulse.AY_numint=sum(data.AY.pulsecut)*0.0001;
pulse.PV_AYnum=pulse.AY_numint/(pulse.time.AYend-pulse.time.AYstart);
% pulse value (integrace matlab)
pom.AYtime=pulse.time.AYstart:(pulse.time.AYend-pulse.time.AYstart)/10000:pulse.time.AYend;
pom.AYspline=spline(data.time.axis,data.AY.cut,pom.AYtime);
pulse.AY_matlint=trapz(pom.AYtime,pom.AYspline);
pulse.PV_AYinteg=pulse.AY_matlint/(pulse.time.AYend-pulse.time.AYstart);
% zpis
pulse.AYvalues1(prom,1)=pulse.PV_AYnum;
pulse.AYvalues2(prom,1)=pulse.PV_AYinteg;

% OFFTRACK
pom.OFFtime=data.time.axis;
pom.OFFtime(1:data.time.pulsestart*data.rate)=[];

data.OFF.YRcut=data.YR.cut;
data.OFF.YRcut(1:data.time.pulsestart*data.rate)=[];
data.OFF.YRint=cumtrapz(pom.OFFtime,data.OFF.YRcut);

data.v.cut(1:data.time.pulsestart*data.rate)=[];
data.v.cutms=data.v.cut./3.6;
data.OFF.vy=data.v.cutms.*sind(data.OFF.YRint);

data.OFF.y=cumtrapz(pom.OFFtime,data.OFF.vy)';
pulse.OFF=max(data.OFF.y);
pulse.OFFvalues(prom,1)=pulse.OFF;

% vykreslen prbh YR a AY
fig1=figure('Visible','Off');
hold all;
plot(data.time.axis,data.x.cut,'g','LineWidth',1.5);
plot(data.time.axis,data.YR.cut,'r','LineWidth',1.5);
plot(data.time.axis,data.AY.cut,'b','LineWidth',1.5);
plot([pulse.time.YRstart,pulse.time.YRstart],[-2,6],'--r','LineWidth',1.5);
plot([pulse.time.AYstart,pulse.time.AYstart],[-2,6],'--b','LineWidth',1.5);
plot([pulse.time.YRend,pulse.time.YRend],[-2,6],'-.r','LineWidth',1.5);
plot([pulse.time.AYend,pulse.time.AYend],[-2,6],'-.b','LineWidth',1.5);
axis([0 data.time.total -0.5 3]);
legend('x','YR','AY','PV-YR start','PV-AY start','PV-YR end','PV-AY end');
grid;
title('Pulse overview','fontsize',13,'fontweight','b');
xlabel('Time [s]','fontsize',11);
ylabel('PV','fontsize',11);
text(-50,-30,strcat(casename,'-run',pom.name3),'Units','pixels');
saveas(fig1,strcat(pom.folder,'/OUTPUT/',pom.name1,pom.name2,pom.name3,'.png'));
close;

fig2=figure('Visible','Off');
hold all;
plot(data.time.axis,data.YR.cut,'r','LineWidth',1.5);
plot(data.time.axis,data.AY.cut,'b','LineWidth',1.5);
plot([pulse.time.YRstart,pulse.time.YRstart],[-2,6],'--r','LineWidth',1.5);
plot([pulse.time.AYstart,pulse.time.AYstart],[-2,6],'--b','LineWidth',1.5);
plot([pulse.time.YRend,pulse.time.YRend],[-2,6],'-.r','LineWidth',1.5);
plot([pulse.time.AYend,pulse.time.AYend],[-2,6],'-.b','LineWidth',1.5);
axis([min(pulse.time.AYstart,pulse.time.YRstart)-0.1 min(pulse.time.AYstart,...
    pulse.time.YRstart)+(data.time.pulsedur+0.2) 0 3]);
legend('YR','AY','PV-YR start','PV-AY start','PV-YR end','PV-AY end');
grid;
title('Pulse detail','fontsize',13,'fontweight','b');
xlabel('Time [s]','fontsize',11);
ylabel('PV','fontsize',11);
text(-50,-30,strcat(casename,'-run',pom.name3,'-pulse'),'Units','pixels');
saveas(fig2,strcat(pom.folder,'/OUTPUT/',pom.name1,pom.name2,pom.name3,'_detail.png'));
close;

% naten a vyhodnoceni dat modelu
input.model=load(modelfile);
data.model.time=input.model.inner.CBV.plus.t;
data.model.YR=input.model.outputs.CBV.plus.DEPSILON;
data.model.maxYR=max(abs(data.model.YR));
data.model.maxYRind=find(abs(data.model.YR)==data.model.maxYR);
data.model.midYR=data.model.maxYR/2;
data.model.YRt1=fzero(@(a) interp1(data.model.time,data.model.YR...
    -data.model.midYR,a),data.time.pulsestart);
data.model.YRt2=fzero(@(a) interp1(data.model.time,data.model.YR...
    -data.model.midYR,a),data.time.pulsestart+data.time.pulsedur);
data.model.AY=input.model.outputs.CBV.plus.AY;
data.model.maxAY=max(abs(data.model.AY));
data.model.maxAYind=find(abs(data.model.AY)==data.model.maxAY);
data.model.midAY=data.model.maxAY/2;
data.model.AYt1=fzero(@(a) interp1(data.model.time,data.model.AY...
    -data.model.midAY,a),data.time.pulsestart);
data.model.AYt2=fzero(@(a) interp1(data.model.time,data.model.AY...
    -data.model.midAY,a),data.time.pulsestart+data.time.pulsedur);
pom.name11='_YRoverlay';
pom.name12='_AYoverlay';

% vykreslen porovnn men a modelu
fig3=figure('Visible','Off');
hold all;
plot(data.time.axis,data.x.cut,'g','LineWidth',1.5);
plot(data.model.time,data.model.YR,'k','LineWidth',1.5);
plot([data.model.YRt1,data.model.YRt1],[-2,6],'--k','LineWidth',1.5);
plot([data.model.YRt2,data.model.YRt2],[-2,6],'-.k','LineWidth',1.5);
plot(data.time.axis,data.YR.cut,'r','LineWidth',1.5);
plot([pulse.time.YRstart,pulse.time.YRstart],[-2,6],'--r','LineWidth',1.5);
plot([pulse.time.YRend,pulse.time.YRend],[-2,6],'-.r','LineWidth',1.5);
axis([0 data.time.total -0.5 3]);
grid;
legend('x','YR model','PV-YR model start','PV-YR model end','YR real',...
    'PV-YR real start','PV-YR real end');
title('Yaw Rate overlay','fontsize',13,'fontweight','b');
xlabel('Time [s]','fontsize',11);
ylabel('PV-YR','fontsize',11);
text(-50,-30,strcat(casename,'-run',pom.name3),'Units','pixels');
saveas(fig3,strcat(pom.folder,'/OUTPUT/',pom.name1,pom.name11,pom.name2,pom.name3,'.png'));
close;

fig4=figure('Visible','Off');
hold all;
plot(data.time.axis,data.x.cut,'g','LineWidth',1.5);
plot(data.model.time,data.model.AY,'k','LineWidth',1.5);
plot([data.model.AYt1,data.model.AYt1],[-2,6],'--k','LineWidth',1.5);
plot([data.model.AYt2,data.model.AYt2],[-2,6],'-.k','LineWidth',1.5);
plot(data.time.axis,data.AY.cut,'b','LineWidth',1.5);
plot([pulse.time.AYstart,pulse.time.AYstart],[-2,6],'--b','LineWidth',1.5);
plot([pulse.time.AYend,pulse.time.AYend],[-2,6],'-.b','LineWidth',1.5);
axis([0 data.time.total -0.5 2]);
grid;
legend('x','AY model','PV-AY model start','PV-AY model end','AY real',...
    'PV-AY real start','PV-AY real end');
title('Lateral Acceleration overlay','fontsize',13,'fontweight','b');
xlabel('Time [s]','fontsize',11);
ylabel('PV-AY','fontsize',11);
text(-50,-30,strcat(casename,'-run',pom.name3),'Units','pixels');
saveas(fig4,strcat(pom.folder,'/OUTPUT/',pom.name1,pom.name12,pom.name2,pom.name3,'.png'));
close;

% zpis hodnot pro vpoet stednho signlu
for r=1:length(data.YR.cut)
    data.avg.YR(r,prom)=data.YR.cut(r,1);
    data.avg.AY(r,prom)=data.AY.cut(r,1);
end;

end;

disp('Processing data...');

% vpoet stednho signlu
for r=1:length(data.avg.YR);
    data.avg.YRfin(r,1)=mean(data.avg.YR(r,1:10));
    data.avg.AYfin(r,1)=mean(data.avg.AY(r,1:10));
end;

% vykreslen porovnn stednho signlu men a modelu
fig5=figure('Visible','Off');
hold all;
plot(data.time.axis,data.x.cut,'g','LineWidth',1.5);
plot(data.model.time,data.model.YR,'k','LineWidth',1.5);
plot([data.model.YRt1,data.model.YRt1],[-2,6],'--k','LineWidth',1.5);
plot([data.model.YRt2,data.model.YRt2],[-2,6],'-.k','LineWidth',1.5);
plot(data.time.axis,data.avg.YRfin,'r','LineWidth',1.5);
plot([pulse.time.YRstart,pulse.time.YRstart],[-2,6],'--r','LineWidth',1.5);
plot([pulse.time.YRend,pulse.time.YRend],[-2,6],'-.r','LineWidth',1.5);
axis([0 data.time.total -0.5 3]);
grid;
legend('x','YR model','PV-YR model start','PV-YR model end','YR real',...
    'PV-YR real start','PV-YR real end');
title('Yaw Rate overlay','fontsize',13,'fontweight','b');
xlabel('Time [s]','fontsize',11);
ylabel('PV-YR','fontsize',11);
text(-50,-30,strcat(casename,'-average'),'Units','pixels');
saveas(fig5,strcat(pom.folder,'/OUTPUT/',pom.name1,pom.name11,pom.name2,'_avg.png'));
close;

fig6=figure('Visible','Off');
hold all;
plot(data.time.axis,data.x.cut,'g','LineWidth',1.5);
plot(data.model.time,data.model.AY,'k','LineWidth',1.5);
plot([data.model.AYt1,data.model.AYt1],[-2,6],'--k','LineWidth',1.5);
plot([data.model.AYt2,data.model.AYt2],[-2,6],'-.k','LineWidth',1.5);
plot(data.time.axis,data.avg.AYfin,'b','LineWidth',1.5);
plot([pulse.time.AYstart,pulse.time.AYstart],[-2,6],'--b','LineWidth',1.5);
plot([pulse.time.AYend,pulse.time.AYend],[-2,6],'-.b','LineWidth',1.5);
axis([0 data.time.total -0.5 2]);
grid;
legend('x','AY model','PV-AY model start','PV-AY model end','AY real',...
    'PV-AY real start','PV-AY real end');
title('Lateral Acceleration overlay','fontsize',13,'fontweight','b');
xlabel('Time [s]','fontsize',11);
ylabel('PV-AY','fontsize',11);
text(-50,-30,strcat(casename,'-average'),'Units','pixels');
saveas(fig6,strcat(pom.folder,'/OUTPUT/',pom.name1,pom.name12,pom.name2,'_avg.png'));
close;

% vpoet prmrnch hodnot PV
PV_YRnum_avg=mean(pulse.YRvalues1);
PV_YRinteg_avg=mean(pulse.YRvalues2);
PV_AYnum_avg=mean(pulse.AYvalues1);
PV_AYinteg_avg=mean(pulse.AYvalues2);
OFFinteg_avg=mean(pulse.OFFvalues);

% odchylky PV od prmrnch hodnot
for q=1:10
    pulse.PV_YRnum_dev(q,1)=pulse.YRvalues1(q,1)-PV_YRnum_avg;
    pulse.PV_YRinteg_dev(q,1)=pulse.YRvalues2(q,1)-PV_YRinteg_avg;
    pulse.PV_AYnum_dev(q,1)=pulse.AYvalues1(q,1)-PV_AYnum_avg;
    pulse.PV_AYinteg_dev(q,1)=pulse.AYvalues2(q,1)-PV_AYinteg_avg;
    pulse.OFF_dev(q,1)=pulse.OFFvalues(q,1)-OFFinteg_avg;
end;

% max a min odchylky
pulse.PV_YRnum_dev_max=max(abs(pulse.PV_YRnum_dev));
pulse.PV_YRinteg_dev_max=max(abs(pulse.PV_YRinteg_dev));
pulse.PV_AYnum_dev_max=max(abs(pulse.PV_AYnum_dev));
pulse.PV_AYinteg_dev_max=max(abs(pulse.PV_AYinteg_dev));
pulse.OFF_dev_max=max(abs(pulse.OFF_dev));
pulse.PV_YRnum_dev_min=min(abs(pulse.PV_YRnum_dev));
pulse.PV_YRinteg_dev_min=min(abs(pulse.PV_YRinteg_dev));
pulse.PV_AYnum_dev_min=min(abs(pulse.PV_AYnum_dev));
pulse.PV_AYinteg_dev_min=min(abs(pulse.PV_AYinteg_dev));
pulse.OFF_dev_min=min(abs(pulse.OFF_dev));

% zpis
fid=fopen(strcat(pom.folder,'/OUTPUT/pulse_values_',casename,'.out'),'wt');
pom.numbers=1:10;
pom.export=[pom.numbers',pulse.YRvalues1,pulse.PV_YRnum_dev,pulse.YRvalues2,...
    pulse.PV_YRinteg_dev,pulse.AYvalues1,pulse.PV_AYnum_dev,pulse.AYvalues2,...
    pulse.PV_AYinteg_dev,pulse.OFFvalues,pulse.OFF_dev];
fprintf(fid,'%12s\n\n',casename);
fprintf(fid,'%12s\t%15s\t%15s\t%15s\t%15s\t%15s\t%15s\t%15s\t%15s\t%15s\t%15s\n','number','PV Yaw Rate num',...
    'deviation','PV Yaw Rate integ','deviation','PV Lat Acc num','deviation','PV Lat Acc integ','deviation',...
    'Offtrack','deviation');
fprintf(fid,'%12.1f\t%15.6f\t%15.6f\t%15.6f\t%15.6f\t%15.6f\t%15.6f\t%15.6f\t%15.6f\t%15.6f\t%15.6f\n',pom.export');
fprintf(fid,'%12s\t%15.6f\t%15s\t%15.6f\t%15s\t%15.6f\t%15s\t%15.6f\t%15s\t%15.6f\t%15s\n\n','average',...
    PV_YRnum_avg,' ',PV_YRinteg_avg,' ',PV_AYnum_avg,' ',PV_AYinteg_avg,' ',OFFinteg_avg,' ');
fprintf(fid,'%12s\t%15s\t%15.6f\t%15s\t%15.6f\t%15s\t%15.6f\t%15s\t%15.6f\t%15s\t%15.6f\n','deviation max',...
    ' ',pulse.PV_YRnum_dev_max,' ',pulse.PV_YRinteg_dev_max,' ',pulse.PV_AYnum_dev_max,...
    ' ',pulse.PV_AYinteg_dev_max,' ',pulse.OFF_dev_max);
fprintf(fid,'%12s\t%15s\t%15.6f\t%15s\t%15.6f\t%15s\t%15.6f\t%15s\t%15.6f\t%15s\t%15.6f\n','deviation min',...
    ' ',pulse.PV_YRnum_dev_min,' ',pulse.PV_YRinteg_dev_min,' ',pulse.PV_AYnum_dev_min,...
    ' ',pulse.PV_AYinteg_dev_min,' ',pulse.OFF_dev_min);
fclose(fid);

save(strcat('XW_PV_',casename,'_data.mat'));

toc;

disp(' ');
disp('-------- DONE --------');